############################################################################
# Modul pro simulaci hry se sirkami mezi dvema strategiemi
# --------------------------------------------------------
#          !!! v tomto souboru nic nemente !!!
############################################################################

from reseni import vymysli_tah_konkretni, vymysli_tah_obecna,\
    vymysli_hloupy_tah_konkretni, vymysli_hloupy_tah_obecna, vymysli_tah_clovek
import re

# mozne vysledky hry
VYHRAL_PRVNI = 1
VYHRAL_DRUHY = 2

# seznam strategii
STRATEGIE = [
    [vymysli_tah_clovek, vymysli_hloupy_tah_konkretni, vymysli_tah_konkretni],
    [vymysli_tah_clovek, vymysli_hloupy_tah_obecna, vymysli_tah_obecna]]
PODULOHY_NAZVY = ['konkretni', 'obecna']
STRATEGIE_NAZVY = ['clovek', 'hloupa', 'chytra']


def hra(strategie1, strategie2, pocet_sirek, povolene_tahy,
        vypis=False, konkretni=False):
    """Provede jednu hru sire mezi dvema strategiemi
    """
    podmineny_vypis(vypis, '\n' + ' HRA '.center(60, '#'))
    strategie = {1: strategie1, 2: strategie2}
    kolo = 1
    while True:
        cislo_hrace = 1 if (kolo % 2 == 1) else 2
        podmineny_vypis(vypis, stav_hry(kolo, cislo_hrace, pocet_sirek))
        # detekce prohry (= zbyva mene sirek nez je nejmensi mozny tah)
        if pocet_sirek < min(povolene_tahy):
            podmineny_vypis(vypis, 'Nelze provest zadny tah!')
            return konec_hry(cislo_hrace, vypis)
        # pokud je hromadka neprazdna, nechame strategii vymyslet tah
        try:
            odebrat_sirek = strategie[cislo_hrace](pocet_sirek) if konkretni\
                else strategie[cislo_hrace](pocet_sirek, povolene_tahy)
        except Exception:
            print 'Chyba pri vypoctu strategie.'
            return konec_hry(cislo_hrace, vypis)
        # kontrola validity tahu
        if not validni_tah(odebrat_sirek, pocet_sirek, povolene_tahy):
            if odebrat_sirek is None:
                podmineny_vypis(vypis, 'Strategie nevratila zadnou hodnotu.')
            else:
                podmineny_vypis(vypis, 'Zvoleny tah (%s) nelze provest.'
                                       % odebrat_sirek)
            return konec_hry(cislo_hrace, vypis)
        # provedeni tahu
        pocet_sirek -= odebrat_sirek
        podmineny_vypis(vypis, 'Odebrano sirek: ' + str(odebrat_sirek))
        kolo += 1


def podmineny_vypis(podminka, text):
    if podminka:
        print text


def stav_hry(kolo, cislo_hrace, pocet_sirek):
    return '\n### kolo {kolo}, hrac {hrac}\nPocet sirek: {sirek}'.format(
        kolo=kolo, hrac=cislo_hrace, sirek=pocet_sirek)


def validni_tah(odebrat_sirek, pocet_sirek, povolene_tahy):
    """Vraci True, pokud je dany tah (odebrat_sirek) mozne provest
    """
    return odebrat_sirek in povolene_tahy and odebrat_sirek <= pocet_sirek


def konec_hry(cislo_hrace, vypis=False):
    """Urci vysledek hry a pokud vypis=True, vypise informaci o vitezstvi
    """
    if cislo_hrace == 2:
        vysledek = VYHRAL_PRVNI
    else:
        vysledek = VYHRAL_DRUHY
    if vypis:
        if vysledek == VYHRAL_PRVNI:
            print '\n### Vyhral zacinajici hrac ###'
        else:
            print '\n### Vyhral nezacinajici hrac ###'
    return vysledek


if __name__ == '__main__':
    print '#' * 60
    print '# SIRKY'
    print '#' * 60
    try:
        # volba podulohy
        print 'Vyber podulohu:'
        for i, nazev_podulohy in enumerate(PODULOHY_NAZVY):
            print '   - (' + str(i) + ')', nazev_podulohy
        volba_poduloha = input('Poduloha: ')
        # volba strategie
        print 'Vyber strategii:'
        for i, nazev_strategie in enumerate(STRATEGIE_NAZVY):
            print '   - (' + str(i) + ')', nazev_strategie
        volba_strategie1 = input('Strategie zacinajiciho hrace: ')
        volba_strategie2 = input('Strategie nezacinajiciho hrace: ')
        strategie1 = STRATEGIE[volba_poduloha][volba_strategie1]
        strategie2 = STRATEGIE[volba_poduloha][volba_strategie2]
        konkretni = (PODULOHY_NAZVY[volba_poduloha] == 'konkretni')
        # volba poctu sirek
        pocet_sirek = int(raw_input('Pocet sirek na hromadce: '))
        # povolene tahy
        if konkretni:
            povolene_tahy = [1, 2, 3]
        else:
            # povolene tahy
            povolene_tahy = raw_input('Povolene tahy (oddelte carkami): ')
            povolene_tahy = map(int, re.findall(r'\d+', povolene_tahy))
        hra(strategie1, strategie2, pocet_sirek, povolene_tahy,
            vypis=True, konkretni=konkretni)
    except Exception:
        print 'Chybne zadany vstup.'
